<?php
/**
 * Menu principal - Navigation Senatory style
 * 
 * Ce fichier contient le menu de navigation principal utilisé sur toutes les pages.
 * Il nécessite que la variable $content soit définie et contienne la section 'navigation'.
 * 
 * @param array $content - Tableau de contenu avec la clé 'navigation'
 * @param string $currentPage - Page actuelle ('index.php', 'pourquoi.php', etc.) pour ajuster les liens
 */

// Fonction d'échappement HTML si elle n'existe pas déjà
if (!function_exists('esc')) {
  function esc($value): string {
    return htmlspecialchars((string)($value ?? ''), ENT_QUOTES, 'UTF-8');
  }
}

// Déterminer la page actuelle si non fournie
if (!isset($currentPage)) {
  $currentPage = basename($_SERVER['PHP_SELF']);
}

// Déterminer si on est sur la page d'accueil
$isHomePage = ($currentPage === 'index.php' || $currentPage === 'index.html' || $currentPage === '');

?>
<!-- Barre de navigation - Senatory style -->
<nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top shadow-sm" aria-label="Navigation principale">
  <div class="container">
    <a class="navbar-brand fw-bold" href="<?= $isHomePage ? '#hero' : 'index.php' ?>" aria-label="<?= esc($content['navigation']['brand_aria'] ?? '') ?>">
      <i class="bi bi-compass"></i>
      <span class="ms-2"><?= esc($content['navigation']['brand_label'] ?? '') ?></span>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" aria-controls="nav" aria-expanded="false" aria-label="Basculer la navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <?php foreach (($content['navigation']['items'] ?? []) as $item): ?>
          <?php 
          // Si le lien commence par #, ajouter index.php devant si on n'est pas sur la page d'accueil
          $href = $item['href'] ?? '#';
          if (strpos($href, '#') === 0 && !$isHomePage) {
            $href = 'index.php' . $href;
          }
          ?>
          <li class="nav-item"><a class="nav-link" href="<?= esc($href) ?>"><?= esc($item['label'] ?? '') ?></a></li>
        <?php endforeach; ?>
        <?php if (!empty($content['navigation']['cta'])): ?>
          <?php 
          $ctaHref = $content['navigation']['cta']['href'] ?? '#';
          if (strpos($ctaHref, '#') === 0 && !$isHomePage) {
            $ctaHref = 'index.php' . $ctaHref;
          }
          ?>
          <li class="nav-item"><a class="btn btn-sm btn-outline-gold ms-lg-2" href="<?= esc($ctaHref) ?>"><?= esc($content['navigation']['cta']['label'] ?? '') ?></a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>

